VERSION 5.00
Begin VB.Form frmRS 
   Caption         =   "Reed-Solomon Demo"
   ClientHeight    =   3795
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   5685
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   ScaleHeight     =   3795
   ScaleWidth      =   5685
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdRSCalc 
      Caption         =   "Calculate"
      Height          =   492
      Left            =   4320
      TabIndex        =   6
      Top             =   2040
      Width           =   972
   End
   Begin VB.TextBox txtRSOutput 
      Height          =   372
      Left            =   480
      Locked          =   -1  'True
      TabIndex        =   3
      Top             =   2760
      Width           =   2052
   End
   Begin VB.TextBox txtRSInput 
      Height          =   372
      Left            =   480
      TabIndex        =   1
      Top             =   720
      Width           =   4692
   End
   Begin VB.CommandButton cmdRSExit 
      Caption         =   "Exit"
      Height          =   492
      Left            =   4320
      TabIndex        =   0
      Top             =   2760
      Width           =   972
   End
   Begin VB.Label lblRSOutput 
      Caption         =   "Output"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   600
      TabIndex        =   5
      Top             =   2400
      Width           =   732
   End
   Begin VB.Label lblRSInput 
      Caption         =   "Input"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   252
      Left            =   600
      TabIndex        =   4
      Top             =   360
      Width           =   732
   End
   Begin VB.Label lblRS 
      Alignment       =   2  'Center
      Appearance      =   0  'Flat
      BackColor       =   &H00C0E0FF&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "Reed-Solomon Algorithm"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H80000008&
      Height          =   612
      Left            =   1560
      TabIndex        =   2
      Top             =   1560
      Width           =   1812
   End
End
Attribute VB_Name = "frmRS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdRSCalc_Click()
    
    Dim tmpStr As String
    Dim symStr As String
    Dim slen As Integer
    Dim i As Integer
    Dim dp As Integer
    Dim rc As Integer
    
    Dim nCodeWord As Integer
    Dim ICodeWord(0 To 64) As Integer
    Dim paritySymb(0 To 3) As Integer
    
    txtRSInput = LTrim(txtRSInput)
    txtRSInput = RTrim(txtRSInput)
    tmpStr = txtRSInput
    slen = Len(txtRSInput)
    i = -1
    
    Do Until i > 30 Or tmpStr = ""
        
        dp = InStr(tmpStr, " ")
        i = i + 1
        If dp = 0 Then
            If (IsNumeric(tmpStr)) Then
                ICodeWord(i) = tmpStr
                Exit Do
            Else
                Call MsgBox("Invalid numeric values entered", vbOKOnly)
                txtRSInput.SetFocus
                Exit Do
            End If
        Else
            symStr = Mid(tmpStr, 1, dp - 1)
            If (IsNumeric(symStr)) Then
                ICodeWord(i) = Val(symStr)
                tmpStr = Mid(tmpStr, dp + 1, Len(tmpStr))
                tmpStr = LTrim(tmpStr)
            Else
                Call MsgBox("Invalid numeric values entered", vbOKOnly)
                txtRSInput.SetFocus
                Exit Do
            End If
        End If
    Loop
    
    nCodeWord = i + 1
    
    For i = 0 To 15           ' TOBEREM -------------
        Print Str(ICodeWord(i))
    Next i
    
    
    Call frmDemo.RSInit
    
    rc = frmDemo.RSEncode(nCodeWord, ICodeWord, paritySymb)
    If rc <> 0 Then
        MsgBox ("Problem with Reed Solomon algorithm")
    End If
    
    txtRSOutput.Text = ""
    For i = 0 To 3
        txtRSOutput = txtRSOutput + Str(paritySymb(i)) + "   "
    Next i


End Sub

Private Sub cmdRSExit_Click()
    Unload Me
End Sub


Private Sub Form_Activate()
    txtRSInput.SetFocus
End Sub

